<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class File extends Model 
{

    protected $table = 'files';
    public $timestamps = true;
    protected $fillable = array('category_id', 'ticket_ID', 'status', 'start_examination', 'end_examination', 'pationt_id');

    public function pationt()
    {
        return $this->belongsTo('App\Models\Pationt');
    }

    public function category()
    {
        return $this->belongsTo('App\Models\Category');
    }

    public function roget()
    {
        return $this->hasOne('App\Models\Roget');
    }

    public function reports()
    {
        return $this->morphMany('App\Models\Report');
    }

}